'--------------------------------------------------------------
'                     (c) 1999-2002 ETT
'--------------------------------------------------------------
'  file: e24lc256.BAS
'--------------------------------------------------------------
$baud = 9600
$crystal = 8000000
Config Scl = Portc.0
Config Sda = Portc.1
Config I2cdelay = 5
Declare Sub Write_eeprom(byval H As Byte , Byval L As Byte , Byval Value As Byte)
Declare Sub Read_eeprom(byval H As Byte , Byval L As Byte , Value As Byte)

Const Addressw = &HA8                                       'slave write address
Const Addressr = &HA9                                       'slave read address

Dim B1 As Byte
Dim Value As Byte , Dat As Byte
Dim Adrh As Byte , Adrl As Byte , I As Integer
Print "Test EEPROM 24LC256"
Print "Press any key to write data or 'ENTER' key to read old data."

   Dat = Waitkey()
   Print Chr(dat) ;
Do
   If Dat <> &HD Then
   Adrh = 0
   Adrl = 0
      Call Write_eeprom(adrh , Adrl , Dat)                  'write value of three to address 1 of EEPROM

   Do
      Dat = Waitkey()
      Print Chr(dat) ;
      Adrl = Adrl + 1
      If Adrl = 0 Then
         Adrh = Adrh + 1
      End If

         Call Write_eeprom(adrh , Adrl , Dat)               'write value of three to address 1 of EEPROM
  Loop Until Dat = &HD
  Print
  Print
  End If

  Adrh = 0
  Adrl = 0
  Do
   Call Read_eeprom(adrh , Adrl , Value)
   Print Chr(value) ;
   Adrl = Adrl + 1
      If Adrl = 0 Then
         Adrh = Adrh + 1
      End If
  Loop Until Value = &HD
   Print
   Dat = Waitkey()
   Print Chr(dat) ;
Loop Until Dat = 27
End                                                         'end program

'sample of writing a byte to EEPROM 24LC256

Sub Write_eeprom(byval H As Byte , Byval L As Byte , Byval Value As Byte)
    I2cstart                                                'start condition
    I2cwbyte Addressw                                       'slave address
    I2cwbyte H                                              'asdress of EEPROM
    I2cwbyte L
    I2cwbyte Value                                          'value to write
    I2cstop                                                 'stop condition
    Waitms 10                                               'wait for 10 milliseconds
End Sub

Sub Read_eeprom(byval H As Byte , Byval L As Byte , Value As Byte)
   I2cstart                                                 'generate start
   I2cwbyte Addressw                                        'slave adsress
   I2cwbyte H                                               'address of EEPROM
   I2cwbyte L
   I2cstart                                                 'repeated start
   I2cwbyte Addressr                                        'slave address (read)
   I2crbyte Value , Nack                                    'read byte
   I2cstop                                                  'generate stop
End Sub